--------------------------------------------
-- added to compile entity below
--------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
entity and2 is
  generic(rise,fall : time; load : integer);
  port(a, b : in std_logic;
       c : out std_logic);
end and2;
architecture test of and2 is 
  signal tmp : std_logic;
  constant rdelay : time := rise + (load * 2 ns);
  constant fdelay : time := fall + (load * 1 ns);
begin
  tmp <= a and b;
  c <= tmp after rdelay when tmp = '1' else
       tmp after fdelay;
end test;
---------------------------------------------
LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
ENTITY test IS
  GENERIC(rise, fall : TIME; load : INTEGER);
  PORT ( ina, inb, inc, ind : IN std_logic;
         out1, out2 : OUT std_logic);
END test;

ARCHITECTURE test_arch OF test IS
  COMPONENT AND2
    GENERIC(rise, fall : TIME; load : INTEGER); 
    PORT ( a, b : IN std_logic;
           c : OUT std_logic);
  END COMPONENT;
BEGIN
  U1: AND2 GENERIC MAP(10 ns, 12 ns, 3 )
    PORT MAP (ina, inb, out1 );

  U2: AND2 GENERIC MAP(9 ns, 11 ns, 5 )
    PORT MAP (inc, ind, out2 );
END test_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
ENTITY test IS
  GENERIC(rise, fall : TIME;
          load : INTEGER);
  PORT ( ina, inb, inc, ind : IN std_logic;
         out1, out2 : OUT std_logic);
END test;

ARCHITECTURE test_arch OF test IS
  COMPONENT and2
    GENERIC(rise, fall : TIME := 10 NS;
            load : INTEGER := 0);
    PORT ( a, b : IN std_logic;
           c : OUT std_logic);
  END COMPONENT;
BEGIN

  U1: and2 GENERIC MAP(10 ns, 12 ns, 3 )
    PORT MAP (ina, inb, out1 );

  U2: and2 PORT MAP (inc, ind, out2 );

END test_arch;



